;***************************************
;* procs_c.inc file. Some procedures  **
;***************************************
;; procs_c.inc procedures list:
;;  Bputpixel
;;  create_noise
;;  do_font
;;  NextMdraw_all
;;  norm_aligned_lv
;;  normalize_plane_equation
;;  write info
if 0
do_font:
  ; Attempt for making fonts
  ; assembled using 'old', previously implemented
  ; bit character definitions

      push       ebp
      mov        ebp,esp
      sub        esp,100
      and        ebp,-16

      .nodes_ptr equ dword[ebp-4]
      .nod2_ptr  equ dword[ebp-8]
      .tris_ptr  equ dword[ebp-12]
      .nodes_max equ [ebp-16]
      .addx      equ [ebp-32]
      .addy      equ [ebp-48]
      .tc        equ dword[ebp-52]  ; tris counter
      .pc        equ dword[ebp-56]  ; verts counter

      mov        ebx,5000
      malloc     ebx
      mov        .nodes_ptr,eax

      mov        edi,eax
      malloc     ebx
      mov        .nod2_ptr,eax
      malloc     ebx
      mov        .tris_ptr,eax

      xor        eax,eax
      mov        .tc,eax
      mov        .pc,eax
      pcmpeqd    xmm6,xmm6
      pslldq     xmm6,4             ; mask


      mov        edi,.nodes_ptr
      mov        eax,2
      cvtsi2ss   xmm1,eax               ; xm1 = addx
      movaps     xmm2,xmm1              ; xm2 = addy
      pslldq     xmm2,4
      xor        ebx,ebx                ; First I transform single font to
      mov        esi,font_table+62+768  ; vertices field -> list of vertices
      cld                               ; in in some (flat) area.
      mov        ecx,15
      xorps      xmm0,xmm0              ; ex. font_table+62+1024+2 = M
    .lb:                                ; ex. font_table+62+1024+1 = N
      push       ecx                    ; ex. font_table+62+768    = ?
      lodsb
      mov        ecx,8
    .la:
      shr        eax,1
      jc         @f
      movups     [edi],xmm0
      inc        ebx
      add        edi,12

     @@:
      addps      xmm0,xmm1
      loop       .la
      add        esi,15             ; 16  = font line lenght
      andps      xmm0,xmm6          ; xm6 = zero X coord mask
      addps      xmm0,xmm2
      pop        ecx
      loop       .lb


      mov        .nodes_max,edi     ; edi = last position address in nodes list
      mov        eax,0x08080808
      mov        esi,.nodes_ptr
      mov        edi,.nod2_ptr
      mov        ebx,.tris_ptr
      movd       xmm6,eax
      xorps      xmm2,xmm2          ; xm2 = triangles stamp
      xorps      xmm7,xmm7
    .do_fnt:

      mov        edx, cube_pts  ;tetra_points_r
      mov        ecx,8
      movups     xmm0,[esi]
      mov        eax,cube_tris  ;tetra_triangles


   @@:
      movlps     xmm1,[edx]
      pmovsxbd   xmm1,xmm1
      cvtdq2ps   xmm1,xmm1
      addps      xmm1,xmm0
      movups     [edi],xmm1
      movlps     xmm3,[eax]
      paddb      xmm3,xmm2
      punpcklbw  xmm3,xmm7

      punpcklwd  xmm3,xmm7
      movups     [ebx],xmm3
      add        edx,3
      add        edi,12
      add        ebx,12
      add        eax,3
      inc        .pc
      inc        .tc
      loop       @b




      paddb      xmm2,xmm6
      add        esi,12
      cmp        esi,.nodes_max
      jne        .do_fnt

      mfree      [triangles_ptr]
      mfree      [points_r_ptr]
      push       .nod2_ptr
      pop        [points_r_ptr]
      push       .tris_ptr
      pop        [triangles_ptr]
      push       .pc
      pop        [points_count_var]
      push       .tc
      pop        [triangles_count_var]
      add        esp,100
      pop        ebp
ret
end if
;===========================================================
macro calc_reflected_ray a,b,c
;in:
;a -   normal vector
;b -   light vector
;out:
;c -   reflected ray
{
  movaps   c,a
  andps    c,[zero_hgst_dd]
  mulps    c,b
  haddps   c,c
  haddps   c,c
  mulps    c,a
  mulps    c,[the_two]
  subps    c,b
}

macro calc_refracted_ray n,l,cn,d,t,f
;in:
;n  -    Normal vector - unit vector of surface
;l  -    Light vector  - unit light vect
;cn -    broadCasted N - transparency factor
;d  -    Dot pr <n,l>
;t  -    Tmp
;out:
;f  -    reFracted ray
{
  movaps t,n
  movaps f,[the_one]
  mulps  t,t
  subps  f,t
  movaps t,cn
  mulps  t,cn
  mulps  f,t
  movaps t,[the_one]
  subps  t,f
  sqrtps t,t
  movaps f,d
  mulps  f,cn
  addps  t,f
  mulps  t,n
  movaps f,cn
  mulps  f,l
  subps  f,t
}

;===========================================================
create_noise:
; random:
;  in  - ecx - min
;        edx - max
;  out - eax - random number

    mov   edi,noise_buff
    cld
    mov   ecx,250 * 255
    cld
  .lb:
    push  ecx
    mov   ecx,-210
    mov   edx,210
    call  random
    stosw
    pop   ecx
    loop  .lb

ret
;============================================================
Bputpixel:   ; Next Mesh edit
; in: eax - x + y shl 16
;     cl  - markup
;     esi - color 0x00rrggbb

  mov     ebx,(BYRES-5) shl 16 +BXRES-5
  movd    xmm0,ebx
  mov     ebx,5 shl 16 +5
  movd    xmm1,ebx
  movd    xmm2,eax
  pmaxsw  xmm2,xmm1
  pminsw  xmm2,xmm0
  movd    eax,xmm2
  mov     edx,BXRES
  movzx   ebx,ax
  shr     eax,16
  mul     edx
  add     eax,ebx
  shl     eax,2
  add     eax,[bbuffer_ptr] ;Bbuffer

;  push   esi
;  push   eax

;  mov    esi,menu_data
;  xor    eax,eax
;  mov    ebx,-110
;  cmp    [esi+8],word 16
;  cmove  eax,ebx
;  imul   eax,BXRES
;  pop    ebx
;  add    eax,ebx

;  pop    esi

  mov     edi,eax              ; draw line handle
  and     esi,0x00ffffff
  mov     al,cl                ; cl -> crucial point number
  shl     eax,24
  or      eax,esi
  mov     ebx,BXRES * 4
  sub     ebx,5*4
  sub     edi,2*BXRES*4+20
  mov     ecx,5
  cld
 @@:
  push    ecx
  mov     ecx,5
  rep     stosd
  pop     ecx
  add     edi,ebx
  loop    @b


ret
;============================================================
NextMdraw_all:  ;   Next Mesh edit
;in  eax - dword value to fill,
;    ecx - area size in dwords
;    edi - mem adress
;    addres must be aligned

     push   ebp
     mov    ebp,esp
     sub    esp,128

     .derv_vertNx   equ [ebp-70]
     .Bput_call     equ dword[ebp-74]
     .NextBendDerv  equ dword[ebp-78]
     .Nxcn          equ dword[ebp-84]
     .NextMxadd     equ dword[ebp-124]
     .NextMyadd     equ word[ebp-122]
     .NextMzadd     equ word[ebp-120]

     .NextScale     equ word[ebp-116]
     .NextRotat     equ dword[ebp-114]
     .NextScaleXY   equ dword[ebp-110]
     .NextBend1     equ word[ebp-106]
     .NextBend2     equ word[ebp-102]
     .NextBend3     equ word[ebp-98]
     .NextBend4     equ word[ebp-94]

     lea       esi,[NextMxadd]
     lea       edi,.NextMxadd
     cld
     mov       ecx,10
     rep       movsd
     mov       .NextBendDerv,NextBendDerv
     mov       .Nxcn,NEXT_CURV_NUMB
     mov       .Bput_call, Bputpixel
     mov       ecx,BXRES * BYRES
     mov       eax,0xff1f1f1f
     mov       edi,[bbuffer_ptr]  ;Bbuffer
     cld
     rep       stosd
     mov       eax,.NextMxadd  ;xmm0
     mov       cl,1
     mov       esi,0x0000ffff
     call      .Bput_call  ; write bar on Bbuffer area
     mov       ax,.NextMzadd
     shl       eax,16
     mov       ax,5
     mov       cl,2
     mov       esi,0x00ff00ff
     call     .Bput_call
     mov       ax,.NextScale
     shl       eax,16
     mov       ax,BXRES - 10
     mov       cl,3
     mov       esi,0x00ffff00
     call      .Bput_call
     mov       eax,.NextRotat
     mov       cl,4
     mov       esi,0x00ff0f0f
     call      .Bput_call
     mov       eax,.NextScaleXY
     mov       cl,5
     mov       esi,0x0000ff00
     call      .Bput_call
     lea       eax,.NextBend1     ; bend work
     mov       ecx,6
    @@:
     push      ecx
     push      eax
     mov       eax,[eax]
     mov       esi,0x00ffffff
     call      .Bput_call  ; write bar on Bbuffer area
     pop       eax
     pop       ecx
     add       eax,4
     inc       ecx
     cmp       ecx,10
     jne       @b


     lea         eax,.NextBend1
     lea         edi,.derv_vertNx
     xorps       xmm1,xmm1
     mov         ecx,4
   @@:
     movd        xmm0,[eax]
     punpcklwd   xmm0,xmm1
     cvtdq2ps    xmm0,xmm0
     movups      [edi],xmm0   ; x, y, z = 0
     add         edi,12
     add         eax,4
     loop        @b
     mov         eax,.Nxcn
     mov         ebx,1
     lea         ecx,.derv_vertNx
     mov         edx,.NextBendDerv
     xor         esi,esi
     call        calc_long_curve
; calc_long_curve:
; in:
;  eax - curve one segment steps count, must be divisable by 4
;  ebx - curve segments count
;  ecx - curve derives ptr, Bspline - must end redundand
;        first two derives vertices (closed curve)
;  edx - curve_vertices ptr, must be allocated enough memory
;  esi - curve type, 0 - bezier, 1 - bspline

     mov         esi,.NextBendDerv
     mov         ecx,.Nxcn
     mov         eax,BXRES
     cvtsi2ss    xmm1,eax
     xorps       xmm2,xmm2
     shufps      xmm1,xmm1,0
   .lll:
     movlps      xmm0,[esi]
     movaps      xmm3,xmm0
     movaps      xmm4,xmm0
     cmpps       xmm3,xmm2,1
     cmpps       xmm4,xmm1,1
     xorps       xmm3,xmm4
     movmskps    eax,xmm3
     and         eax,11b
     cmp         eax,11b
     jne         @f
     cvtps2dq    xmm0,xmm0
     sub         esp,8
     movlps      [esp],xmm0
     pop         edi edx
     imul        edx,BXRES
     add         edi,edx
     shl         edi,2
     add         edi,[bbuffer_ptr]  ;Bbuffer
     mov         [edi],dword 0x30ffffff
   @@:
     add         esi,12
     loop        .lll
     mov         edi, .NextBendDerv   ; after draw - normalize
     mov         ecx, .Nxcn ;dword NEXT_CURV_NUMB
     call        normalize_object
     mov         esp,ebp
     pop         ebp
ret
;==========================================================================
write_info:    ; Display unique edges, vertices, faces count, colided edges
               ; and individual chunks info.
    push ebp
    mov  ebp,esp
    sub  esp,300

    .str_ed   equ  [ebp-300]
    .inf      equ  dword[ebp-4]
    .font     equ  dword[ebp-8]
    .wrtext   equ  dword[ebp-12]
    .infxy    equ  dword[ebp-16]
    .itoa     equ  dword[ebp-20]

    mov        eax,[inf_screen_ptr]

    mov       .inf,eax ; info_screen
    mov       ebx,INFOX shl 2
    imul      eax,ebx
    mov       .font, font_table + 62
    mov       .wrtext, write_text
    mov       .infxy, (INFOX shl 16 + INFOY )
    mov       .itoa,itoa

    cld
    xor    eax,eax          ; clear draw buffer
    mov    edi,.inf
    mov    ecx,INFOX * INFOY
    rep    stosd

    mov    eax,5 shl 16 + 2
    mov    edx,16
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi,uniq_ed
    mov    edi,.inf
    call   .wrtext

; unsigned dword integer to ascii procedure
;     in   eax - variable
;          esi - Pointer to ascii string
;   out    esi - desired ascii string
;          edi - end of ascii string  - ptr to memory

    mov    eax,[edges_count]
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

;   eax - x * 65536 + y -> where to display
;   ebx - pointer to character table
;   ecx - size x * 65536 + size y -> size of scr buffer
;   esi - pointer to ASCIIZ string to display
;   edi - pointer to scr buffer

    mov    eax,5 shl 16 + 19
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext


    mov    eax,5 shl 16 + 36
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi,faces
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    mov    eax,[triangles_count_var]
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

    mov    eax,5 shl 16 + 36 + 17
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    mov    eax,5 shl 16 + 36 + 17*2
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi,vertices
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    mov    eax,[points_count_var]
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

    mov    eax,5 shl 16 + 36 + 3*17
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    cmp    [edges_intersect_ptr],0
    je     @f

    mov    eax,5 shl 16 + 36 + 17*4
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi,edges_inter
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    mov    eax,[edges_coll_count]  ; edges collided count
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

    mov    eax,5 shl 16 + 36 + 17*5
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext
  @@:

    cmp    [chunks_ptr],0
    je     @f
    cmp    [chunks_count],0
    je     @f

    mov    eax,200 shl 16 + 17*0
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi,chunks_info
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    mov    eax,[chunks_count]  ; edges collided count
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

    mov    eax,200 shl 16 + 18
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext
  @@:
  .in_vrr:

    cmp    [inner_vert_ptr],0
    je     @f

    mov    eax,200 shl 16 + 17*2
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi,in_vert_info
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    mov    eax,[inner_vert_number] ; edges collided count
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

    mov    eax,200 shl 16 + 17*3
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext
  @@:
    or      eax,-1
    cmp    [curr_chunk],eax
    je     @f
    mov    eax,200 shl 16 + 17*4
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi, curr_edit_pr_info
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

    mov    eax,[curr_chunk] ; edges collided count
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

    mov    eax,200 shl 16 + 17*5
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext
  @@:

if 0
    mov    eax,[edges_d_count] ; edges collided count
    lea    esi,.str_ed
    call   .itoa
    mov    byte[edi+1],0

    mov    eax,200 shl 16 + 17*6
    mov    ebx,.font
    mov    ecx,.infxy
    lea    esi,.str_ed
    mov    edi,.inf
    mov    edx,16
    call   .wrtext
  @@:

    mov    eax,200 shl 16 + 18 + 17*6
    mov    ebx,.font
    mov    ecx,.infxy
    mov    esi,double_edges_info ;curr_edit_pr_info
    mov    edi,.inf
    mov    edx,16
    call   .wrtext

end if


    mov  esp,ebp
    pop  ebp
ret

;======================================================
normalize_plane_equation:
  movups  xmm0,[plane_equation]    ;normalize
  movaps  xmm1,xmm0
  andps   xmm0,[zero_hgst_dd]
  mulps   xmm0,xmm0
  haddps  xmm0,xmm0
  haddps  xmm0,xmm0
  rsqrtps xmm0,xmm0
  mulps   xmm1,xmm0     ; xmm1 - normalized plane equat.
  movups  [plane_equation],xmm1
ret


;===========================================================
norm_aligned_lv:     ; normalise aligned light vectors
;  in edi -> lights_ptr
;     ecx -> lights count
    @@:
     movaps  xmm0,[edi]
     movaps  xmm1,[edi]
     mulps   xmm1,xmm1
     andps   xmm0,[zero_hgst_dd]
     haddps  xmm1,xmm1
     haddps  xmm1,xmm1
     rsqrtps xmm1,xmm1
     mulps   xmm0,xmm1
     movaps  [edi],xmm0
     add     edi,64
     loop    @b
ret
